/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.commands;

import ikr.simtree.commands.AddCommand;
import ikr.simtree.commands.CleanCommand;
import ikr.simtree.commands.CollectCommand;
import ikr.simtree.commands.Command;
import ikr.simtree.commands.CommandDesc;
import ikr.simtree.commands.ControlCommand;
import ikr.simtree.commands.DumpCommand;
import ikr.simtree.commands.EvalCommand;
import ikr.simtree.commands.ExecCommand;
import ikr.simtree.commands.GUICommand;
import ikr.simtree.commands.ListCommand;
import ikr.simtree.commands.NullCommand;
import ikr.simtree.commands.PrepareCommand;
import ikr.simtree.commands.QueryCommand;
import ikr.simtree.commands.RemoveCommand;
import ikr.simtree.commands.SimulateCommand;
import ikr.simtree.commands.UnlockCommand;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.Options;

public abstract class CommandFactory {
    public static Command create(CommandDesc commandDesc, Options optionList, SimTreeContext sc) {
        Command command = null;
        assert (commandDesc != null);
        switch (commandDesc.commandEnum) {
            case ADD: {
                command = new AddCommand(commandDesc, optionList, sc);
                break;
            }
            case REMOVE: {
                command = new RemoveCommand(commandDesc, optionList, sc);
                break;
            }
            case PREPARE: {
                command = new PrepareCommand(commandDesc, optionList, sc);
                break;
            }
            case LIST: {
                command = new ListCommand(commandDesc, optionList, sc);
                break;
            }
            case SIMULATE: {
                command = new SimulateCommand(commandDesc, optionList, sc);
                break;
            }
            case EXEC: {
                command = new ExecCommand(commandDesc, optionList, sc);
                break;
            }
            case CLEAN: {
                command = new CleanCommand(commandDesc, optionList, sc);
                break;
            }
            case UNLOCK: {
                command = new UnlockCommand(commandDesc, optionList, sc);
                break;
            }
            case EVAL: {
                command = new EvalCommand(commandDesc, optionList, sc);
                break;
            }
            case CONTROL: {
                command = new ControlCommand(commandDesc, optionList, sc);
                break;
            }
            case QUERY: {
                command = new QueryCommand(commandDesc, optionList, sc);
                break;
            }
            case DUMP: {
                command = new DumpCommand(commandDesc, optionList, sc);
                break;
            }
            case COLLECT: {
                command = new CollectCommand(commandDesc, optionList, sc);
                break;
            }
            case NULL: {
                command = new NullCommand(commandDesc, optionList, sc);
                break;
            }
            case GUI: {
                command = new GUICommand(commandDesc, optionList, sc);
                break;
            }
            case INTRO: 
            case SPEC: 
            case ADVANCED: 
            case HELP: 
            case FULLHELP: 
            case NEWS: {
                assert (false);
                break;
            }
        }
        assert (command != null);
        return command;
    }
}

