/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.commands;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.commands.CommandEnum;
import ikr.simtree.commands.CommandVariantEnum;

public class CommandDesc {
    public final CommandEnum commandEnum;
    public final CommandVariantEnum commandVariantEnum;

    public CommandDesc(CommandEnum commandEnum, CommandVariantEnum commandVariantEnum) {
        this.commandEnum = commandEnum;
        this.commandVariantEnum = commandVariantEnum;
    }

    public static CommandDesc factory(String commandName) throws SimTreeException {
        CommandEnum commandEnum = CommandEnum.getCommandEnumFromName(CommandDesc.commandNameWithoutVariant(commandName));
        CommandVariantEnum commandVariantEnum = null;
        if (commandName.length() == 0) {
            throw new SimTreeException("Missing command");
        }
        if (commandEnum == null) {
            throw new SimTreeException("Invalid command " + commandName);
        }
        String commandVariantString = CommandDesc.commandVariantString(commandName);
        if (commandVariantString != null) {
            commandVariantEnum = CommandVariantEnum.getCommandVariantEnumFromName(commandVariantString);
            if (commandVariantEnum == null) {
                throw new SimTreeException("Invalid command variant " + commandVariantString);
            }
            if (!commandEnum.isValidVariant(commandVariantEnum)) {
                throw new SimTreeException("Command variant " + commandVariantEnum.commandVariantName + " not supported by command");
            }
        }
        return new CommandDesc(commandEnum, commandVariantEnum);
    }

    private static String commandNameWithoutVariant(String commandName) {
        if (commandName.contains("-")) {
            return commandName.substring(0, commandName.indexOf(45));
        }
        return commandName;
    }

    private static String commandVariantString(String commandName) {
        int index = commandName.indexOf(45);
        if (index == -1) {
            return null;
        }
        if (commandName.length() > index) {
            return commandName.substring(index + 1, commandName.length());
        }
        return "";
    }

    public String toCommandString() {
        return String.valueOf(this.commandEnum.commandName) + (this.commandVariantEnum != null ? "-" + this.commandVariantEnum.commandVariantName : "");
    }
}

