/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.commands;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.commands.CommandDesc;
import ikr.simtree.commands.CommandVariantEnum;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.Option;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.Options;
import ikr.simtree.options.ResultDefOption;
import ikr.simtree.options.SingleArgOption;

public abstract class Command {
    private final CommandDesc commandDesc;
    protected final SimTreeContext sc;
    private final Options options;

    protected Command(CommandDesc commandDesc, Options options, SimTreeContext sc) {
        this.commandDesc = commandDesc;
        this.options = options;
        this.sc = sc;
        assert (commandDesc != null);
        assert (commandDesc.commandEnum.isValidVariant(commandDesc.commandVariantEnum));
    }

    public abstract void doIt() throws SimTreeException;

    protected CommandDesc getCommandDesc() {
        return this.commandDesc;
    }

    protected boolean hasCommandVariant(CommandVariantEnum variant) {
        return this.commandDesc.commandVariantEnum == variant;
    }

    protected Option getOption(OptionEnum optionEnum) {
        return this.options.getOption(optionEnum);
    }

    protected SingleArgOption getSingleArgOption(OptionEnum optionEnum) {
        return (SingleArgOption)this.options.getOption(optionEnum);
    }

    protected Options getOptions(OptionEnum optionEnum) {
        return this.options.getOptions(optionEnum);
    }

    protected boolean isBoolOptionSet(OptionEnum optionEnum) {
        return this.options.isBoolOptionSet(optionEnum);
    }

    protected boolean isSimTreeParent() {
        return this.options.isSimTreeParent();
    }

    protected ResultDefOption getCheckedResultDefOption() throws SimTreeException {
        return this.options.getCheckedResultDefOption(this.commandDesc.commandEnum);
    }

    protected boolean allowRemoteControl() {
        return this.commandDesc.commandEnum.allowRemoteControl;
    }
}

