/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.cmdrun;

import ikr.simtree.control.channel.UpstreamMessageCollector;
import java.util.LinkedList;
import java.util.List;

public class CommandOutputHandler {
    private static final int MAX_LIST_LINES = 1024;
    private static final String OVERFLOW_ERR_MSG = "=== Too many lines, rest truncated";
    public static final CommandOutputHandler simpleCommandOutputHandler = new CommandOutputHandler(false, false, null, false);
    private final List<String> stringList;
    protected final boolean pushUp;
    protected final String saveFileName;
    protected final UpstreamMessageCollector remoteStatusCollector;

    public CommandOutputHandler(boolean doWriteList, boolean doPushUp, String saveFileName, boolean doCollectStatusMessages) {
        this.pushUp = doPushUp;
        this.saveFileName = saveFileName;
        this.stringList = doWriteList ? new LinkedList<String>() : null;
        this.remoteStatusCollector = doCollectStatusMessages ? new UpstreamMessageCollector() : null;
    }

    public List<String> getStringList() {
        assert (this.stringList != null);
        return this.stringList;
    }

    public UpstreamMessageCollector getUpstreamMessageCollector() {
        assert (this.remoteStatusCollector != null);
        return this.remoteStatusCollector;
    }

    public void addToStringList(String s) {
        if (this.stringList == null) {
            return;
        }
        if (this.stringList.size() < 1024) {
            this.stringList.add(s);
        } else if (this.stringList.size() == 1024) {
            this.stringList.add(OVERFLOW_ERR_MSG);
        }
    }

    protected void addStatusMessage(String s) {
        if (this.remoteStatusCollector == null) {
            return;
        }
        this.remoteStatusCollector.addMessage(s);
    }
}

