/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.base;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.StringPair;
import ikr.simtree.base.StringPairs;
import ikr.simtree.parafile.AttributeList;
import ikr.simtree.parafile.AttributesLists;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public abstract class StringPairsFileReader {
    public static StringPairs readSimpleFile(String absFileName, boolean ignoreError) throws SimTreeException {
        StringPairs ret = new StringPairs();
        BufferedReader input = null;
        try {
            try {
                input = new BufferedReader(new FileReader(absFileName));
                String line = null;
                while ((line = input.readLine()) != null) {
                    StringPair sp = StringPairsFileReader.readStringPair(line);
                    if (sp == null) continue;
                    ret.add(sp);
                }
            }
            catch (IOException e) {
                if (!ignoreError) {
                    throw new SimTreeException("Error reading file " + absFileName + " (" + e.getMessage() + ")");
                }
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e2) {
                    if (!ignoreError) {
                        throw new SimTreeException("Error closing file " + absFileName + " (" + e2.getMessage() + ")");
                    }
                }
            }
        }
        finally {
            block17: {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e) {
                    if (ignoreError) break block17;
                    throw new SimTreeException("Error closing file " + absFileName + " (" + e.getMessage() + ")");
                }
            }
        }
        return ret;
    }

    public static StringPairs readSimpleFile(String absFileName) throws SimTreeException {
        return StringPairsFileReader.readSimpleFile(absFileName, false);
    }

    public static AttributesLists readAttributesListsFile(String absFileName) throws SimTreeException {
        AttributesLists ret = new AttributesLists();
        BufferedReader input = null;
        try {
            try {
                String line;
                input = new BufferedReader(new FileReader(absFileName));
                boolean inList = false;
                AttributeList attributeList = null;
                String ERR = "Error reading attribute file " + absFileName + ", format error: ";
                while ((line = input.readLine()) != null) {
                    if ((line = line.trim()).startsWith("[")) {
                        if (!line.endsWith("]")) {
                            throw new SimTreeException(String.valueOf(ERR) + "Line starting with [ does not end with ]");
                        }
                        if (line.length() < 4) {
                            throw new SimTreeException(String.valueOf(ERR) + "Line too short");
                        }
                        String[] spa = line.substring(1, line.length() - 1).split("\\Q,\\E");
                        if (spa.length != 2) {
                            throw new SimTreeException(String.valueOf(ERR) + "Line oes not contain two strings separated with ,");
                        }
                        StringPair sp = new StringPair(spa[0].trim(), spa[1].trim());
                        if (attributeList != null) {
                            ret.addAttributeList(attributeList);
                        }
                        attributeList = new AttributeList(sp);
                        inList = true;
                        continue;
                    }
                    if (!inList) {
                        throw new SimTreeException(String.valueOf(ERR) + "File does not start with [SimPara,Value]");
                    }
                    assert (attributeList != null);
                    StringPair sp = StringPairsFileReader.readStringPair(line);
                    if (sp == null) continue;
                    attributeList.addAttribute(sp);
                }
                if (attributeList != null) {
                    ret.addAttributeList(attributeList);
                }
            }
            catch (IOException e) {
                throw new SimTreeException("Error reading file " + absFileName + " (" + e.getMessage() + ")");
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                throw new SimTreeException("Error closing file " + absFileName + " (" + e.getMessage() + ")");
            }
        }
        return ret;
    }

    private static StringPair readStringPair(String line) {
        String l = line.trim();
        if (l.startsWith("#") || l.length() == 0) {
            return null;
        }
        int index = l.indexOf(61);
        if (index == -1 || index == 0) {
            return new StringPair(l, "");
        }
        return new StringPair(l.substring(0, index).trim(), l.substring(index + 1).trim());
    }
}

