/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.base;

import ikr.simtree.base.FileOPs;
import ikr.simtree.base.Helpers;
import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.StringPair;
import ikr.simtree.base.StringPairs;
import ikr.simtree.base.StringPairsFileReader;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.vfs.StudyRootVFS;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

public abstract class Props {
    public static final String OUTERR_FILENAME_BASE = "st.s.outerr_filename_base.1";
    public static final String REDIR_FILENAME_MID = "st.s.redir_filename_mid.2";
    public static final String PARAMETER_FILENAME = "st.s.parameter_filename.1";
    public static final String PARSER_LOG_FILENAME = "st.s.parser_log_filename.1";
    public static final String SIMPROG_REDIR_FILENAME_BASE = "st.s.simprog_redir_filename_base.1";
    public static final String REDIR_ERR_FILENAME_EXT = "st.s.redir_err_filename_ext.1";
    public static final String REDIR_OUT_FILENAME_EXT = "st.s.redir_out_filename_ext.1";
    public static final String CONFIG_FILENAME_EXT = "st.s.config_filename_ext.1";
    public static final String COMPRESS_RESULT_FILES_BY_SIMTREE = "st.b.compress_result_files_by_simtree.1";
    public static final String COMPRESS_RESULT_FILES_BY_SIMLIB = "st.b.compress_result_files_by_simlib.1";
    public static final String COMPRESS_OUTPUT_FILES = "st.b.compress_output_files.1";
    public static final String CREATE_OUTPUT_FILES = "st.b.create_output_files.1";
    public static final String COMPRESSION_METHOD = "st.i.compression_method.1";
    public static final String CONTROL_COMMUNICAITON_METHOD = "st.s.control_communication_method.1";
    public static final String CALLSIM_NICE_LEVEL = "st.i.callsim_nice_level.1";
    public static final String CREATE_DEFAULT_BATCHES_RESULT_FILES = "st.b.create_default_batches_result_files.1";
    public static final String CREATE_SEEDED_BATCHES_RESULT_FILES = "st.b.create_seeded_batches_result_files.1";
    public static final String CREATE_DROP_RESULT_FILES = "st.b.create_drop_result_files.1";
    public static final String DELETE_EXPORT_RESULT_FILES_AFTER_COLLECT = "st.b.delete_export_result_files_after_collect.1";
    public static final String PARAFILE_TEMPLATE_FILENAME = "st.s.parafile_template_filename.1";
    public static final String ATTRIBUTES_FILENAME = "st.s.attributes_filename.1";
    public static final String MAX_EVAL_PRINTSERVER_DEPTH = "st.i.max_eval_printserver_depth.1";
    public static final String NUM_PARSER_THREADS = "st.i.num_parser_threads.1";
    public static final String MAX_SEED_INDEX = "st.i.max_seed_index.1";
    public static final String NOTIFY_PARENT_CONDITION = "st.b.notify_parent_condition.1";
    public static final String NOTIFY_CHILD_CONDITION = "st.b.notify_child_condition.1";
    public static final String NOTIFY_SIMULATION_CONDITION = "st.b.notify_simulation_condition.1";
    public static final String MESSAGE_TYPES_SHOWN = "st.s.message_types_shown.2";
    public static final String ENABLE_REMOTE_CONTROL = "st.b.enable_remote_control.1";
    private static final String[][] defaultProps = new String[][]{{"st.s.outerr_filename_base.1", "simtree", "base name for simtree created files (stdout, stderr, config), specifics and extension are appended"}, {"st.s.redir_filename_mid.2", "callsim", "mid name for outfile of callsim-script redirection"}, {"st.b.create_default_batches_result_files.1", "true", "whether result files for default batches are created during a simulation run"}, {"st.b.create_seeded_batches_result_files.1", "false", "whether result files for seeded batches are created during a simulation run"}, {"st.b.create_drop_result_files.1", "false", "whether drop result files are created during a simulation run"}, {"st.b.delete_export_result_files_after_collect.1", "false", "whether export result files are deleted after a successful collect run"}, {"st.s.parameter_filename.1", "sim.par", "name of generated simulation parameter file"}, {"st.s.parser_log_filename.1", "sim.par.log", "name of generated simulation parameter parser logfile"}, {"st.s.simprog_redir_filename_base.1", "simprog", "(no longer used)"}, {"st.s.redir_out_filename_ext.1", ".stdout", "file extension used for redirected stdout files"}, {"st.s.redir_err_filename_ext.1", ".stderr", "file extension used for redirected stderr files"}, {"st.s.config_filename_ext.1", ".conf", "file extension used for config files"}, {"st.b.compress_result_files_by_simtree.1", "true", "whether SimTree should compress result files using the defined compression method"}, {"st.b.compress_result_files_by_simlib.1", "false", "whether the SimLib (simulation binary) should compress result files (requires SimLib 2.7.1 or later)"}, {"st.b.create_output_files.1", "true", "whether stdout/stderr output files of simulation/collect runs are created"}, {"st.b.compress_output_files.1", "false", "whether compress stdout/stderr output files of simulation/collect runs"}, {"st.i.compression_method.1", "2", "compression method (0 = unpacked, 1 = gzip, 2 = bzip2, 3 = lzma), tools must be installed"}, {"st.i.callsim_nice_level.1", "19", "nice level used by the callsim hook"}, {"st.i.max_eval_printserver_depth.1", "30", "maximal depth of print server path for parser"}, {"st.i.num_parser_threads.1", "2", "number of threads used for the parser thread pool"}, {"st.i.max_seed_index.1", "127", "largest accepted seed index for seeded batches"}, {"st.s.parafile_template_filename.1", "sim.par.template", "name of the simulation parameter template file, may be overwritten with option"}, {"st.s.attributes_filename.1", "sim.par.attributes", "name of the (optional) attributes file with parameter file replacements"}, {"st.b.notify_parent_condition.1", "false", "condition-notifier: Notify SimTree parent process condition"}, {"st.b.notify_child_condition.1", "false", "condition-notifier: Notify SimTree child process condition"}, {"st.b.notify_simulation_condition.1", "false", "condition-notifier: Notify Start/Finish of simulation/collect run"}, {"st.s.message_types_shown.2", "notice,status,config,hints", "List of message types (notice, status, config, hints) printed, others are always shown"}, {"st.b.enable_remote_control.1", "false", "whether enable remote control of running processes"}, {"st.s.control_communication_method.1", "helper", "method use for communication betweeen control client and server (helper, dbus)"}};
    private static final HashMap<String, String> currentProps = new LinkedHashMap<String, String>();
    private static StringPairs readedFromFile = null;

    public static void init(String absFileName) throws SimTreeException {
        String[][] stringArray = defaultProps;
        int n = defaultProps.length;
        int n2 = 0;
        while (n2 < n) {
            String[] arr = stringArray[n2];
            currentProps.put(arr[0], arr[1]);
            ++n2;
        }
        if (absFileName != null && FileOPs.isFileReadable(new File(absFileName))) {
            readedFromFile = StringPairsFileReader.readSimpleFile(absFileName);
            for (StringPair pair : readedFromFile) {
                currentProps.put(pair.firstStr, pair.secondStr);
            }
            Iterator<String> it = currentProps.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next();
                String val = null;
                String[][] stringArray2 = defaultProps;
                int n3 = defaultProps.length;
                int n4 = 0;
                while (n4 < n3) {
                    String[] dStr = stringArray2[n4];
                    if (dStr[0].equals(key)) {
                        val = dStr[1];
                        break;
                    }
                    ++n4;
                }
                if (val != null) continue;
                it.remove();
            }
        }
        Props.checkConsistency();
    }

    public static void init() throws SimTreeException {
        Props.init(null);
    }

    public static void save(String absFileName, boolean makeDelay, SimTreeContext sc) throws SimTreeException {
        boolean haveToSave = false;
        if (readedFromFile == null) {
            haveToSave = true;
        } else if (readedFromFile.size() != currentProps.keySet().size()) {
            haveToSave = true;
        } else {
            for (StringPair strP : readedFromFile) {
                if (currentProps.get(strP.firstStr) != null && currentProps.get(strP.firstStr).equals(strP.secondStr)) continue;
                haveToSave = true;
            }
        }
        if (haveToSave) {
            StringPairs saveList = new StringPairs();
            for (String key : currentProps.keySet()) {
                saveList.add(new StringPair(key, currentProps.get(key)));
            }
            Helpers.writeStringPairsToFile(absFileName, saveList, "SimTree properties - handle with care, values are not checked, entries will change without notice", defaultProps);
            Message.config("Wrote properties file " + StudyRootVFS.reduceName(absFileName), sc);
            if (makeDelay) {
                Helpers.pauseThread(2000L);
            }
        }
    }

    private static void checkConsistency() throws SimTreeException {
        if (Props.getInt(COMPRESSION_METHOD) < 0 || Props.getInt(COMPRESSION_METHOD) > 3) {
            throw new SimTreeException("Inconsistent property st.i.compression_method.1");
        }
        if (Props.getBool(COMPRESS_RESULT_FILES_BY_SIMLIB) && Props.getBool(COMPRESS_RESULT_FILES_BY_SIMTREE)) {
            throw new SimTreeException("Inconsistent properties st.b.compress_result_files_by_simlib.1 and st.b.compress_result_files_by_simtree.1");
        }
        if (!Props.getStr(CONTROL_COMMUNICAITON_METHOD).equals("helper") && !Props.getStr(CONTROL_COMMUNICAITON_METHOD).equals("dbus")) {
            throw new SimTreeException("Invalid value for property st.s.control_communication_method.1");
        }
    }

    public static String getStr(String key) {
        assert (key.startsWith("st.s"));
        String ret = currentProps.get(key);
        assert (ret != null);
        return ret;
    }

    public static boolean getBool(String key) throws SimTreeException {
        assert (key.startsWith("st.b"));
        String val = currentProps.get(key);
        assert (val != null);
        if (val.length() == 0) {
            throw new SimTreeException("Invalid empty value for property key " + key + "(" + val + ")");
        }
        if (val.equals("true")) {
            return true;
        }
        if (val.equals("false")) {
            return false;
        }
        throw new SimTreeException("Invalid boolean value for property key " + key + "(" + val + ")");
    }

    public static int getInt(String key) throws SimTreeException {
        assert (key.startsWith("st.i"));
        String val = currentProps.get(key);
        assert (val != null);
        if (val.length() == 0) {
            throw new SimTreeException("Invalid empty value for property key " + key + "(" + val + ")");
        }
        int ret = -1;
        try {
            ret = new Integer(val);
        }
        catch (NumberFormatException e) {
            throw new SimTreeException("Invalid number format for property key " + key + "(" + val + ")");
        }
        return ret;
    }

    public static String getCanonKeyName(String key) {
        assert (key.startsWith("st.b.") || key.startsWith("st.s.") || key.startsWith("st.i."));
        String s = key.toUpperCase().replaceAll("[.]", "_").substring(5);
        assert (s.charAt(s.length() - 2) == '_');
        s = s.substring(0, s.length() - 2);
        return s.trim();
    }
}

