/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.base;

import ikr.simtree.base.Helpers;
import ikr.simtree.base.Props;
import ikr.simtree.commands.CommandDesc;
import ikr.simtree.launch.SimTreeContext;
import java.io.IOException;
import javax.swing.JTextArea;

public abstract class Message {
    private static JTextArea sysMessageWindow = null;
    private static int warnings = 0;
    private static int errors = 0;
    private static boolean printNotice = true;
    private static boolean printConfig = true;
    private static boolean printStatus = true;
    private static boolean printHints = true;
    private static String sysMessageLineSep = "";

    public static void init() {
        String messageTypesPrinted = Props.getStr("st.s.message_types_shown.2");
        if (!messageTypesPrinted.contains("notice")) {
            printNotice = false;
        }
        if (!messageTypesPrinted.contains("config")) {
            printConfig = false;
        }
        if (!messageTypesPrinted.contains("status")) {
            printStatus = false;
        }
        if (!messageTypesPrinted.contains("hints")) {
            printHints = false;
        }
    }

    public static void notice(String msg, SimTreeContext sc) {
        if (printNotice) {
            Message.prLineErr("[Notice" + SimTreeContext.instanceStr(sc) + "] ", msg);
        }
    }

    public static void config(String msg, SimTreeContext sc) {
        if (printConfig) {
            Message.prLineErr("[Config" + SimTreeContext.instanceStr(sc) + "] ", msg);
        }
    }

    public static void error(String msg, SimTreeContext sc) {
        Message.prLineErr("[Error" + SimTreeContext.instanceStr(sc) + "]  ", msg);
        ++errors;
    }

    public static void errorCont(String msg, SimTreeContext sc) {
        Message.prLineErr("[Error" + SimTreeContext.instanceStr(sc) + "]  ", msg);
    }

    public static void warning(String msg, SimTreeContext sc) {
        Message.prLineErr("[Warning" + SimTreeContext.instanceStr(sc) + "]", msg);
        ++warnings;
    }

    public static void evalResult(String msg, SimTreeContext sc) {
        Message.prLineErr("[Result" + SimTreeContext.instanceStr(sc) + "] ", msg);
    }

    public static void status(String msg, SimTreeContext sc) {
        if (printStatus) {
            Message.prLineErr("[Status" + SimTreeContext.instanceStr(sc) + "] ", msg);
        }
    }

    public static void remote(String msg, SimTreeContext sc) {
        if (printStatus) {
            Message.prLineErr("[Remote" + SimTreeContext.instanceStr(sc) + "] ", msg);
        }
    }

    public static void debug(String msg) {
        Message.prLineErr("[Debug] ", msg);
    }

    public static void hint(CommandDesc commandDesc, SimTreeContext sc) {
        if (printHints) {
            Message.prLineErr("[Hints" + SimTreeContext.instanceStr(sc) + "]  ", "Please see the Hints-Section in the Command help of " + commandDesc.toCommandString());
        }
    }

    public static void setSysMessageWindow(JTextArea sysMessageWindow) {
        Message.sysMessageWindow = sysMessageWindow;
    }

    public static String getSummaryString() {
        return errors + " Errors, " + warnings + " Warnings";
    }

    public static void fatal(String msg, SimTreeContext sc) {
        Message.error(msg, sc);
        Helpers.setExitValue(-1);
        Message.status(Message.getSummaryString(), sc);
        Helpers.exitProgram();
    }

    private static void printToSysMessageWindow(String msg) {
        if (sysMessageWindow != null) {
            sysMessageWindow.append(String.valueOf(sysMessageLineSep) + msg);
            sysMessageLineSep = "\n";
            sysMessageWindow.setCaretPosition(sysMessageWindow.getText().length());
        }
    }

    private static synchronized void prLineErr(String pre, String msg) {
        String s = String.valueOf(pre) + " " + msg;
        if (sysMessageWindow == null) {
            System.err.println(s);
            System.err.flush();
        }
        Message.printToSysMessageWindow(s);
    }

    private static synchronized void prLineOut(String msg) {
        if (sysMessageWindow == null) {
            System.out.println(msg);
            System.out.flush();
        }
        Message.printToSysMessageWindow(msg);
    }

    public static void errorIOException(IOException e, String msg, SimTreeContext sc) {
        Message.error(String.valueOf(msg) + ": " + e.getMessage(), sc);
    }

    public static void helpLine(String line) {
        Message.prLineOut(line);
    }

    public static void resultOut(String line, String indent) {
        Message.prLineOut(String.valueOf(indent) + line);
    }

    public static void evalResultOut(String line) {
        Message.prLineOut(line);
    }
}

