/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.base;

import ikr.simtree.base.FileOPs;
import ikr.simtree.base.Message;
import ikr.simtree.base.SHelpers;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.StringPair;
import ikr.simtree.base.StringPairs;
import ikr.simtree.base.StringPairsFileReader;
import ikr.simtree.base.Strings;
import ikr.simtree.cmdrun.CommandOutputHandler;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.Option;
import ikr.simtree.options.OptionFactory;
import ikr.simtree.options.OptionSourceEnum;
import ikr.simtree.options.Options;
import ikr.simtree.vfs.StudyRootVFS;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;

public abstract class Helpers {
    private static int exitValue = 0;
    private static final Random random = new Random();
    private static final String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    public static void exitProgram() {
        Helpers.atThreadExit();
        System.exit(Helpers.getExitValue());
    }

    public static void setExitValue(int newExitValue) {
        if (exitValue == 0) {
            exitValue = newExitValue;
        }
    }

    public static int getExitValue() {
        return exitValue;
    }

    public static void atThreadExit() {
        System.err.flush();
        System.out.flush();
    }

    public static void createFileFromTemplate(BufferedReader templateReader, String absTargetFileName, StringPairs values) throws SimTreeException {
        assert (templateReader != null);
        File targetFile = new File(absTargetFileName);
        if (targetFile.exists()) {
            targetFile.delete();
        }
        if (targetFile.exists()) {
            throw new SimTreeException("Cannot overrite file " + absTargetFileName + ", delete failed");
        }
        String sep = System.getProperty("line.separator");
        BufferedWriter output = null;
        String failString = null;
        try {
            String line;
            output = new BufferedWriter(new FileWriter(absTargetFileName));
            int lineNum = 1;
            while ((line = templateReader.readLine()) != null) {
                if (line.contains("%%")) {
                    for (StringPair valuePair : values) {
                        line = line.replaceAll("%%" + valuePair.firstStr + "%%", valuePair.secondStr);
                    }
                }
                if (line.contains("%%")) {
                    failString = "Created file " + absTargetFileName + " would contain replacement pattern in line " + lineNum + " after doing all given replacements";
                    break;
                }
                output.write(String.valueOf(line) + sep);
                ++lineNum;
            }
        }
        catch (IOException ex) {
            failString = "Cannot create file: " + ex.getMessage();
        }
        try {
            if (output != null) {
                ((Writer)output).close();
            }
            templateReader.close();
        }
        catch (IOException ex) {
            failString = "Cannot close file: " + ex.getMessage();
        }
        if (failString != null) {
            throw new SimTreeException(failString);
        }
    }

    public static void createFileFromTemplate(String absTemplateFileName, String absTargetFileName, StringPairs values) throws SimTreeException {
        try {
            Helpers.createFileFromTemplate(new BufferedReader(new FileReader(new File(absTemplateFileName))), absTargetFileName, values);
        }
        catch (IOException ex) {
            throw new SimTreeException("File not found");
        }
    }

    public static String randomString(int length) {
        char[] buf = new char[length];
        int i = 0;
        while (i < buf.length) {
            buf[i] = chars.charAt(random.nextInt(chars.length()));
            ++i;
        }
        return new String(buf);
    }

    public static void pauseThread(long milliSeconds) {
        try {
            Thread.sleep(milliSeconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String getHostName() {
        String hostName = "";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostName.trim();
    }

    public static void printFailedProgramOutputStdErr(int cmdExitValue, CommandOutputHandler stderrSpec, String failedCommandString, SimTreeContext sc) {
        Message.error("Subprocess returned " + cmdExitValue, sc);
        Message.errorCont(failedCommandString, sc);
        if (!stderrSpec.getStringList().isEmpty()) {
            Message.errorCont("The failed command said on its stderr", sc);
            Message.errorCont(String.valueOf(SHelpers.indent(1)) + "| -----------------------------------------------", sc);
            for (String str : stderrSpec.getStringList()) {
                Message.errorCont(String.valueOf(SHelpers.indent(1)) + "| " + str, sc);
            }
            Message.errorCont(String.valueOf(SHelpers.indent(1)) + "| -----------------------------------------------", sc);
        } else {
            Message.errorCont(String.valueOf(SHelpers.indent(1)) + "The failed command gave no output", sc);
        }
        Message.errorCont("", sc);
    }

    public static String readLineNonBlocking(BufferedReader reader) throws IOException {
        if (!reader.ready()) {
            Helpers.pauseThread(250L);
        } else {
            String s = reader.readLine();
            if (s != null) {
                return s;
            }
        }
        return null;
    }

    public static void writeConfigFile(String absFileName, Options options, String heading) throws SimTreeException {
        StringPairs list = new StringPairs();
        for (Option option : options) {
            list.add(option.createConfigFileStringPair());
        }
        Helpers.writeStringPairsToFile(absFileName, list, heading, null);
    }

    public static Options readOptionFile(File optionsFile, OptionSourceEnum source, SimTreeContext sc) throws SimTreeException {
        assert (optionsFile != null);
        Options optionList = new Options(sc);
        if (FileOPs.isFileReadable(optionsFile)) {
            Message.notice("Reading options file " + StudyRootVFS.reduceName(optionsFile.getAbsolutePath()), sc);
            StringPairs list = StringPairsFileReader.readSimpleFile(optionsFile.getAbsolutePath());
            for (StringPair pair : list) {
                Strings argList = new Strings();
                if (pair.secondStr == null || pair.secondStr.length() == 0) {
                    Option o = OptionFactory.create(pair.firstStr, argList, source, sc);
                    if (o == null) continue;
                    optionList.add(o);
                    continue;
                }
                String[] stringArray = pair.secondStr.split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    argList.add(element);
                    ++n2;
                }
                optionList.add(OptionFactory.create(pair.firstStr, argList, source, sc));
            }
        }
        return optionList;
    }

    public static void writeStringPairsToFile(String absFileName, StringPairs list, String comment, String[][] comments) throws SimTreeException {
        assert (absFileName != null);
        File file = new File(absFileName);
        if (file.exists()) {
            file.delete();
        }
        if (file.exists()) {
            throw new SimTreeException("Cannot overwrite file " + absFileName);
        }
        BufferedWriter output = null;
        try {
            try {
                output = new BufferedWriter(new FileWriter(absFileName));
                if (comment != null) {
                    output.write("# " + comment);
                }
                output.newLine();
                output.write("");
                output.newLine();
                for (StringPair pair : list) {
                    boolean comment_added = false;
                    if (comments != null) {
                        String[][] stringArray = comments;
                        int n = comments.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String[] arr = stringArray[n2];
                            if (arr.length == 3 && arr[0].equals(pair.firstStr)) {
                                output.write("# " + arr[2]);
                                output.newLine();
                                comment_added = true;
                            }
                            ++n2;
                        }
                    }
                    if (pair.secondStr != null && pair.secondStr.length() != 0) {
                        output.write(String.valueOf(pair.firstStr.trim()) + " = " + pair.secondStr.trim());
                    } else {
                        output.write(pair.firstStr);
                    }
                    output.newLine();
                    if (!comment_added) continue;
                    output.newLine();
                }
                output.write("");
                output.newLine();
                output.write("# End of file");
                output.newLine();
                output.flush();
            }
            catch (IOException e) {
                throw new SimTreeException("Cannot write file " + absFileName + "(" + e.getMessage() + ")");
            }
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException e) {
                throw new SimTreeException("Cannot close file " + absFileName + "(" + e.getMessage() + ")");
            }
        }
    }
}

