/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.base;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.vfs.StudyRootVFS;
import java.io.File;

public abstract class FileOPs {
    private static void touchDir(File dir) {
        if (dir.isDirectory()) {
            dir.setLastModified(dir.lastModified());
        }
    }

    public static final int mkDirs(String newDirName) throws SimTreeException {
        File newDir = new File(newDirName);
        if (newDir.exists()) {
            if (!newDir.isDirectory()) {
                throw new SimTreeException("mkDir: " + newDirName + " already exists but is not a directory");
            }
            return 0;
        }
        if (!newDir.mkdirs()) {
            throw new SimTreeException("mkDir: Cannot create " + newDirName + ", Protections?");
        }
        return 1;
    }

    public static final int rmDir(String dirToRemoveName) throws SimTreeException {
        File dirToRemove = new File(dirToRemoveName);
        assert (dirToRemove.getAbsolutePath().startsWith(StudyRootVFS.getStudyRoot()));
        if (!dirToRemove.exists()) {
            return 0;
        }
        if (!dirToRemove.delete()) {
            String[] content = FileOPs.listDir(dirToRemove);
            if (content.length != 0) {
                return 0;
            }
            throw new SimTreeException("Cannot delete empty directory (Protections?) " + dirToRemove);
        }
        return 1;
    }

    public static final int rmFile(String fileToRemoveName) {
        File fileToRemove = new File(fileToRemoveName);
        assert (fileToRemove.getAbsolutePath().startsWith(StudyRootVFS.getStudyRoot()));
        if (!fileToRemove.exists()) {
            return 0;
        }
        if (!fileToRemove.delete()) {
            return 0;
        }
        return 1;
    }

    private static void iCleanDirRecursively(String absDirName, boolean removeTheDir) throws SimTreeException {
        String[] dirContent;
        File thisDir = new File(absDirName);
        FileOPs.touchDir(thisDir);
        assert (thisDir.getAbsolutePath().startsWith(StudyRootVFS.getStudyRoot()));
        String[] stringArray = dirContent = FileOPs.listDir(thisDir);
        int n = dirContent.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            String thisEntry = thisDir + File.separator + entry;
            File thisFile = new File(thisEntry);
            if (thisFile.isFile()) {
                FileOPs.rmFile(thisEntry);
            } else if (thisFile.isDirectory()) {
                FileOPs.iCleanDirRecursively(thisEntry, true);
            }
            ++n2;
        }
        if (removeTheDir) {
            FileOPs.rmDir(absDirName);
        }
    }

    public static void cleanDirRecursively(String absDirName) throws SimTreeException {
        FileOPs.iCleanDirRecursively(absDirName, false);
    }

    public static String[] listDir(File dirToList) throws SimTreeException {
        assert (dirToList.isDirectory());
        FileOPs.touchDir(dirToList);
        String[] dirContent = dirToList.list();
        if (dirContent == null) {
            throw new SimTreeException("Cannot read content of directory " + dirToList.getAbsolutePath() + ", maybe out of resources");
        }
        return dirContent;
    }

    public static String[] listDir(String absDirToListName) throws SimTreeException {
        return FileOPs.listDir(new File(absDirToListName));
    }

    public static boolean isDirEmpty(String absDirName) throws SimTreeException {
        File dir = new File(absDirName);
        FileOPs.touchDir(dir);
        if (!dir.isDirectory()) {
            throw new SimTreeException("Directory " + dir.getAbsolutePath() + " does not exist");
        }
        return FileOPs.listDir(dir).length == 0;
    }

    public static boolean isDir(String absDirName) {
        return FileOPs.isDir(new File(absDirName));
    }

    public static boolean isDir(File dir) {
        return dir.isDirectory();
    }

    public static boolean isFileReadable(File file) {
        return FileOPs.existsFile(file) && file.canRead();
    }

    public static boolean isFileReadable(String fileName) {
        return FileOPs.isFileReadable(new File(fileName));
    }

    public static boolean existsFile(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            FileOPs.touchDir(parent);
        }
        return file.isFile();
    }

    public static boolean existsFile(String fileName) {
        return FileOPs.existsFile(new File(fileName));
    }

    public static String toAbsolutePath(String fileName) {
        return new File(fileName).getAbsolutePath();
    }
}

