/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree;

import ikr.simtree.base.FileOPs;
import ikr.simtree.base.Helpers;
import ikr.simtree.base.Message;
import ikr.simtree.base.Props;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.StringPair;
import ikr.simtree.base.Strings;
import ikr.simtree.commandline.CommandLine;
import ikr.simtree.commandline.UnparsedOption;
import ikr.simtree.commandline.UnparsedOptions;
import ikr.simtree.commands.AdvancedCommand;
import ikr.simtree.commands.CommandDesc;
import ikr.simtree.commands.CommandEnum;
import ikr.simtree.commands.CommandFactory;
import ikr.simtree.commands.FullHelpCommand;
import ikr.simtree.commands.HelpCommand;
import ikr.simtree.commands.IntroCommand;
import ikr.simtree.commands.NewsCommand;
import ikr.simtree.commands.SpecCommand;
import ikr.simtree.control.comm.ControlServerRunner;
import ikr.simtree.gui.MainFrame;
import ikr.simtree.help.TextFormatter;
import ikr.simtree.hooks.ConditionEnum;
import ikr.simtree.hooks.ConditionNotifyCreator;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.launch.SimTreeEventEnum;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.OptionSourceEnum;
import ikr.simtree.options.Options;
import ikr.simtree.runsim.SimThread;
import ikr.simtree.vfs.StudyRootVFS;

public class SimTree {
    private static final String ENV_STUDYROOT = "SIMTREE_STUDYROOT";
    private static CommandDesc commandDesc = null;
    private static Options commandLineOptions = null;
    private static ControlServerRunner controlServerRunner = null;

    public static void main(String[] args) {
        SimTreeContext sc = new SimTreeContext();
        try {
            SimTree.staticInit(args, sc);
            SimTree.waitForOtherThreadsTerminated();
            SimTree.staticFinalize(sc);
            Helpers.exitProgram();
        }
        catch (SimTreeException e) {
            Message.fatal(e.getMessage(), sc);
        }
    }

    private static void staticInit(String[] args, SimTreeContext sc) throws SimTreeException {
        CommandLine commandLine = new CommandLine(args);
        if (commandLine.getCommand().equals("check")) {
            assert (OptionEnum.isConsistent());
            Helpers.exitProgram();
        }
        SimTree.printProgName();
        commandDesc = null;
        try {
            commandDesc = CommandDesc.factory(commandLine.getCommand());
        }
        catch (SimTreeException e) {
            Message.error(e.getMessage(), sc);
            HelpCommand.doItStatic(commandDesc, null, sc);
            Helpers.exitProgram();
        }
        assert (commandDesc != null);
        SimTree.handleHelpCommands(commandLine, sc);
        SimTree.setStudyRoot(commandLine.getUnparsedOptions());
        StudyRootVFS.checkStudyRoot(sc);
        Props.init(StudyRootVFS.getPropertiesFileName());
        Message.init();
        if (SimTree.commandDesc.commandEnum != CommandEnum.PREPARE) {
            StudyRootVFS.checkStudyRootSubDirs();
        }
        commandLineOptions = Options.fromUnparsedOptions(commandLine.getUnparsedOptions(), OptionSourceEnum.COMMAND_LINE, sc);
        if (SimTree.commandDesc.commandEnum != CommandEnum.PREPARE && commandLineOptions.isSimTreeParent()) {
            Props.save(StudyRootVFS.getPropertiesFileName(), true, sc);
        }
        if (commandLineOptions.isSimTreeParent()) {
            ConditionNotifyCreator.createAndExecute("st.b.notify_parent_condition.1", ConditionEnum.SIMTREE_PARENT_STARTED, StudyRootVFS.getTempDirName(), new StringPair("COMMAND", SimTree.commandDesc.commandEnum.commandName), sc);
        } else {
            ConditionNotifyCreator.createAndExecute("st.b.notify_child_condition.1", ConditionEnum.SIMTREE_CHILD_STARTED, StudyRootVFS.getTempDirName(), new StringPair("COMMAND", SimTree.commandDesc.commandEnum.commandName), sc);
        }
        sc.setCurrentCommand(SimTree.commandDesc.commandEnum);
        controlServerRunner = null;
        if (SimTree.commandDesc.commandEnum.allowRemoteControl && commandLineOptions.isSimTreeParent() && Props.getBool("st.b.enable_remote_control.1")) {
            controlServerRunner = ControlServerRunner.factory(sc);
            controlServerRunner.startControl();
        }
        Message.notice("Using StudyRoot " + StudyRootVFS.getStudyRoot(), sc);
        new SimTree(commandDesc, commandLineOptions, sc);
        if (SimTree.commandDesc.commandEnum == CommandEnum.PREPARE) {
            Props.save(StudyRootVFS.getPropertiesFileName(), false, sc);
        }
    }

    private static void staticFinalize(SimTreeContext sc) throws SimTreeException {
        if (controlServerRunner != null) {
            controlServerRunner.stopControl();
        }
        Message.status(Message.getSummaryString(), sc);
        StringPair[] replacements = new StringPair[]{new StringPair("COMMAND", SimTree.commandDesc.commandEnum.commandName), new StringPair("STATUS", Message.getSummaryString())};
        if (commandLineOptions.isSimTreeParent()) {
            ConditionNotifyCreator.createAndExecute("st.b.notify_parent_condition.1", ConditionEnum.SIMTREE_PARENT_FINISHED, StudyRootVFS.getTempDirName(), replacements, sc);
        } else {
            ConditionNotifyCreator.createAndExecute("st.b.notify_child_condition.1", ConditionEnum.SIMTREE_CHILD_FINISHED, StudyRootVFS.getTempDirName(), replacements, sc);
        }
    }

    public SimTree(CommandDesc commandDesc, Options commandLineOptions, SimTreeContext sc) throws SimTreeException {
        Message.notice("Launching SimTree " + commandDesc.toCommandString(), sc);
        Options options = Options.handle(commandLineOptions, commandDesc.commandEnum, sc);
        CommandFactory.create(commandDesc, options, sc).doIt();
        sc.onEvent(SimTreeEventEnum.SIMTREE_INSTANCE_FINISHED);
    }

    private static void waitForOtherThreadsTerminated() {
        Helpers.pauseThread(1000L);
        do {
            Helpers.pauseThread(500L);
        } while (SimThread.areSimThreadsRunning() || MainFrame.isGUIRunning());
    }

    private static void printProgName() {
        System.err.println("IKR SimTree Version 2.7.0beta16 (C) 2012-2014 University of Stuttgart, IKR");
    }

    private static void setStudyRoot(UnparsedOptions unparsedOptions) throws SimTreeException {
        UnparsedOptions srOptions = OptionEnum.STUDY_ROOT.fromUnparsedOptions(unparsedOptions);
        if (srOptions.size() > 1) {
            throw new SimTreeException("Only one option" + OptionEnum.STUDY_ROOT.hlp11 + "is allowed");
        }
        if (srOptions.size() == 1) {
            Strings args = ((UnparsedOption)srOptions.get((int)0)).arguments;
            if (args.size() != 1) {
                throw new SimTreeException("Option" + OptionEnum.STUDY_ROOT.hlp11 + "needs exactly one argument");
            }
            StudyRootVFS.setStudyRoot((String)((UnparsedOption)srOptions.get((int)0)).arguments.get(0));
        } else {
            String sr = FileOPs.toAbsolutePath(".");
            String env = System.getenv(ENV_STUDYROOT);
            if (env != null && env.length() != 0) {
                sr = env;
            }
            assert (sr != null);
            StudyRootVFS.setStudyRoot(sr);
        }
    }

    private static void handleHelpCommands(CommandLine commandLine, SimTreeContext sc) throws SimTreeException {
        if (SimTree.commandDesc.commandEnum == CommandEnum.HELP) {
            HelpCommand.doItStatic(commandDesc, commandLine.getUnparsedOptions(), sc);
            Helpers.exitProgram();
        }
        if (OptionEnum.HELP.fromUnparsedOptions(commandLine.getUnparsedOptions()).size() != 0) {
            new TextFormatter(SimTree.commandDesc.commandEnum.getFullHelp()).print();
            Helpers.exitProgram();
        }
        if (SimTree.commandDesc.commandEnum == CommandEnum.INTRO) {
            IntroCommand.doItStatic(commandDesc, commandLine.getUnparsedOptions(), sc);
            Helpers.exitProgram();
        }
        if (SimTree.commandDesc.commandEnum == CommandEnum.SPEC) {
            SpecCommand.doItStatic(commandDesc, commandLine.getUnparsedOptions(), sc);
            Helpers.exitProgram();
        }
        if (SimTree.commandDesc.commandEnum == CommandEnum.ADVANCED) {
            AdvancedCommand.doItStatic(commandDesc, commandLine.getUnparsedOptions(), sc);
            Helpers.exitProgram();
        }
        if (SimTree.commandDesc.commandEnum == CommandEnum.NEWS) {
            NewsCommand.doItStatic(commandDesc, commandLine.getUnparsedOptions());
            Helpers.exitProgram();
        }
        if (SimTree.commandDesc.commandEnum == CommandEnum.FULLHELP) {
            FullHelpCommand.doItStatic(commandDesc, commandLine.getUnparsedOptions());
            Helpers.exitProgram();
        }
    }
}

